import { hexColorToCSSFilter } from '../../library/utils/CSSUtils';

const styles = () => ({
    container: {
        height: '100%',
        display: 'flex',
        flexDirection: 'row',
        alignItems: 'stretch',
        paddingTop: 40
    },
    supportContainer: {
        display: 'flex',
        flexDirection: 'row',
        alignItems: 'center',
        color: '#ffffff',
        fontWeight: 400,
        fontSize: '14px',
        position: 'absolute',
        bottom: 20,
        left: 20,
        cursor: 'pointer'
    },
    supportIcon: {
        marginRight: 8
    },
    leftContainer: {
        display: 'flex',
        flexDirection: 'column',
        paddingLeft: 26,
        width: 280
    },
    titleIcon: {
        height: 86,
        width: 130,
        marginBottom: 20
    },
    titleText: {
        color: '#ffffff',
        fontSize: 34,
        fontStyle: 'italic',
        fontWeight: 'bold',
        marginBottom: 10,
        fontFamily: 'Roboto-Condensed'
    },
    subTitleText: {
        color: '#ffffff',
        fontSize: 16
    },
    rightContainer: {
        backgroundColor: '#fcfcfc',
        width: 416,
        maxWidth: 416,
        minWidth: 416,
        boxShadow: '0px 30.1132px 60.2264px rgba(0, 0, 0, 0.15)',
        borderRadius: 10,
        marginLeft: 'auto',
        marginBottom: 40,
        padding: 20,
        paddingRight: 64,
        paddingLeft: 64,
        display: 'flex',
        flexDirection: 'column',
        position: 'relative',
        alignItems: 'center',
        justifyContent: 'center',
        boxSizing: 'border-box'
    },
    language: {
        alignSelf: 'flex-end',
        position: 'absolute !important',
        right: 20,
        top: 20
    },
    signInContainer: {
        display: 'flex',
        flexDirection: 'column',
        alignSelf: 'center',
        width: '100%'
    },
    signInTitle: {
        fontStyle: 'italic',
        fontWeight: 'bold',
        fontSize: 28,
        color: '#232428',
        textAlign: 'center',
        marginBottom: 8,
        fontFamily: 'Roboto-Condensed'
    },
    countryIcon: {
        marginRight: 5,
        marginTop: -3,
        width: 26,
        height: 22
    },
    signInEmail: {
        width: '100%',
        marginTop: '28px !important',
        '& input': {
            fontFamily: 'Lato',
            fontWeight: 400
        }
    },
    signInButton: {
        marginTop: 32,
        height: 36,
        backgroundColor: '#00A4D9',
        textTransform: 'none',
        '&:hover': {
            backgroundColor: '#016f95'
        },
        '&:disabled': {
            backgroundColor: '#00A4D9',
            color: '#FFFFFF',
            opacity: 0.6
        },
        '& span': {
            fontFamily: 'Roboto-Condensed',
            fontWeight: 700
        }
    },
    signUpContainer: {
        position: 'absolute',
        bottom: 24,
        left: 0,
        fontSize: 12,
        color: '#7F7F7F',
        display: 'flex',
        flexDirection: 'row',
        width: '100%',
        justifyContent: 'center'
    },
    signUpLink: {
        textTransform: 'uppercase',
        color: '#00A4D9',
        cursor: 'pointer',
        marginLeft: 3,
        fontWeight: 'bold'
    },
    loadingButton: {},
    backContainer: {
        position: 'absolute',
        top: 36,
        left: 51,
        textTransform: 'uppercase',
        fontWeight: 'bold',
        fontSize: 12,
        color: '#00A4D9',
        display: 'flex',
        flexDirection: 'row',
        alignItems: 'center',
        cursor: 'pointer'
    },
    backIcon: {
        marginRight: 5
    },
    verifySubTitle: {
        color: '#737478',
        fontSize: 16
    },
    verifyWarning: {
        color: '#FF2D43',
        textTransform: 'uppercase',
        fontSize: 14,
        marginTop: 10
    },
    resendingEmailContainer: {
        position: 'absolute',
        right: 0,
        left: 0,
        top: 0,
        bottom: 0,
        backgroundColor: 'rgba(0,0,0,0.5)',
        zIndex: 999,
        display: 'flex',
        alignItems: 'center',
        justifyContent: 'center'
    },
    marketingApprovalContainer: {
        display: 'flex',
        flexDirection: 'row',
        alignItems: 'flex-start',
        cursor: 'pointer',
        marginTop: 17
    },
    marketingApprovalIcon: {
        width: 18,
        minWidth: 18,
        height: 18,
        minHeight: 18,
        marginRight: 11,
        filter: hexColorToCSSFilter('#009EDC')
    },
    marketingApprovalText: {
        fontSize: 12,
        color: '#2A2D34'
    },
    agreeTOS: {
        textAlign: 'center',
        fontSize: 12,
        marginTop: 32,
        paddingLeft: 20,
        paddingRight: 20,
        color: '#2A2D34',
        '& a': {
            color: '#2A2D34',
            textDecoration: 'underline',
            fontWeight: 'bold'
        }
    },
    countrySelector: {
        borderBottom: '1px solid #949494'
    },
    countryDefaultValue: {
        color: '#a2a2a2'
    },
    generalError: {
        color: '#ff0000',
        fontSize: 12
    },
    languageMenuItem: {
        '& img': {
            marginRight: 5,
            marginTop: 3,
            width: 26,
            height: 22
        }
    },
    countryMenuItem: {
        '& img': {
            marginRight: 5,
            marginTop: -3,
            width: 26,
            height: 22
        }
    },
    languageSelect: {
        display: 'flex !important',
        '& img': {
            marginRight: 5,
            marginTop: 0,
            width: 26,
            height: 22
        }
    },
    countryPaper: {
        maxHeight: 195,
        height: 195,
        width: 288,
        maxWidth: 288,
        marginTop: 80
    },
    countrySelect: {
        display: 'flex !important',
        '& img': {
            marginRight: 5,
            marginTop: -1,
            width: 26,
            height: 22
        }
    }
});

export default styles;
